# Generated by default/object.tt
package Paws::CostExplorer::CostCategoryRule;
  use Moose;
  has InheritedValue => (is => 'ro', isa => 'Paws::CostExplorer::CostCategoryInheritedValueDimension');
  has Rule => (is => 'ro', isa => 'Paws::CostExplorer::Expression');
  has Type => (is => 'ro', isa => 'Str');
  has Value => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CostExplorer::CostCategoryRule

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CostExplorer::CostCategoryRule object:

  $service_obj->Method(Att1 => { InheritedValue => $value, ..., Value => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CostExplorer::CostCategoryRule object:

  $result = $service_obj->Method(...);
  $result->Att1->InheritedValue

=head1 DESCRIPTION

Rules are processed in order. If there are multiple rules that match
the line item, then the first rule to match is used to determine that
Cost Category value.

=head1 ATTRIBUTES


=head2 InheritedValue => L<Paws::CostExplorer::CostCategoryInheritedValueDimension>

The value the line item will be categorized as, if the line item
contains the matched dimension.


=head2 Rule => L<Paws::CostExplorer::Expression>

An Expression
(https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
object used to categorize costs. This supports dimensions, tags, and
nested expressions. Currently the only dimensions supported are
C<LINKED_ACCOUNT>, C<SERVICE_CODE>, C<RECORD_TYPE>, and
C<LINKED_ACCOUNT_NAME>.

Root level C<OR> is not supported. We recommend that you create a
separate rule instead.

C<RECORD_TYPE> is a dimension used for Cost Explorer APIs, and is also
supported for Cost Category expressions. This dimension uses different
terms, depending on whether you're using the console or API/JSON
editor. For a detailed comparison, see Term Comparisons
(https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-cost-categories.html#cost-categories-terms)
in the I<AWS Billing and Cost Management User Guide>.


=head2 Type => Str

You can define the C<CostCategoryRule> rule type as either C<REGULAR>
or C<INHERITED_VALUE>. The C<INHERITED_VALUE> rule type adds the
flexibility of defining a rule that dynamically inherits the cost
category value from the dimension value defined by
C<CostCategoryInheritedValueDimension>. For example, if you wanted to
dynamically group costs based on the value of a specific tag key, you
would first choose an inherited value rule type, then choose the tag
dimension and specify the tag key to use.


=head2 Value => Str





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CostExplorer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

