# Generated by default/object.tt
package Paws::SSOAdmin::InstanceMetadata;
  use Moose;
  has IdentityStoreId => (is => 'ro', isa => 'Str');
  has InstanceArn => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSOAdmin::InstanceMetadata

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSOAdmin::InstanceMetadata object:

  $service_obj->Method(Att1 => { IdentityStoreId => $value, ..., InstanceArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSOAdmin::InstanceMetadata object:

  $result = $service_obj->Method(...);
  $result->Att1->IdentityStoreId

=head1 DESCRIPTION

Provides information about the SSO instance.

=head1 ATTRIBUTES


=head2 IdentityStoreId => Str

The identifier of the identity store that is connected to the SSO
instance.


=head2 InstanceArn => Str

The ARN of the SSO instance under which the operation will be executed.
For more information about ARNs, see Amazon Resource Names (ARNs) and
AWS Service Namespaces in the I<AWS General Reference>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSOAdmin>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

