#!/usr/local/bin/perl

# Before 'make install' is run this script should be runnable with
# 'make test'.  After 'make install' it should work as 'perl t/config/random.t'

# A script to test configuration options specific to the
# WordNet::Similarity::random module; specifically, it tests
# whether the maxrand option is accepted and whether all
# the relatedness values, $score, satisfy: 0 <= $score < maxrand.

use strict;
use warnings;

my $num_tests;

BEGIN {
  $num_tests = 208;
}

use Test::More tests => $num_tests;

BEGIN {use_ok ('WordNet::QueryData')}
BEGIN {use_ok ('WordNet::Similarity::random')}

my $wn = new WordNet::QueryData;
ok ($wn);

my $config = "rand$$.txt";
my $maxrand = 3.14159;

ok (open FH, ">$config") or diag "Cannot create temporary config file: $!";
print FH "WordNet::Similarity::random\n";
print FH "trace::0\n";
print FH "cache::0\n";
print FH "maxrand::$maxrand\n";
ok (close FH);

my $module = new WordNet::Similarity::random ($wn, $config);
ok ($module);
my ($err, $errstr) = $module->getError ();
is ($err, 0);

# just test to make sure that all the numbers generated by random are
# less than $maxrand and greater than or equal to 0.
for (1..100) {
  my $score = $module->getRelatedness ("dog#n#1", "cat#n#1");
  cmp_ok ($score, '<', $maxrand);
  cmp_ok ($score, '>=', 0);
}

END {
  ok (unlink $config);
}
