/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.graph.ALink;
import net.sourceforge.plantuml.graph.ALinkImpl;
import net.sourceforge.plantuml.graph.ANode;
import net.sourceforge.plantuml.graph.ANodeImpl;
import net.sourceforge.plantuml.graph.LinkString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Heap {
    private final Map<String, ANode> nodes = new LinkedHashMap<String, ANode>();
    private final Map<ANode, LinkedHashMap<ANode, ALink>> directChildren = new LinkedHashMap<ANode, LinkedHashMap<ANode, ALink>>();
    private final List<ALink> links = new ArrayList<ALink>();

    public boolean isEmpty() {
        if (this.links.isEmpty()) {
            assert (this.nodes.isEmpty());
            assert (this.directChildren.isEmpty());
            return true;
        }
        return false;
    }

    public void importing(ANode aNode, ANode aNode2, Heap heap, int n, Object object) {
        assert (this.directChildren.keySet().contains(aNode));
        assert (this.nodes.values().contains(aNode));
        assert (heap.nodes.values().contains(aNode2));
        assert (heap.directChildren.keySet().contains(aNode2));
        assert (!this.nodes.values().contains(aNode2));
        assert (!this.directChildren.keySet().contains(aNode2));
        assert (!heap.directChildren.keySet().contains(aNode));
        int n2 = this.nodes.size();
        assert (n2 == this.directChildren.size());
        this.nodes.putAll(heap.nodes);
        this.directChildren.putAll(heap.directChildren);
        ALinkImpl aLinkImpl = new ALinkImpl(aNode, aNode2, n, object);
        this.links.add(aLinkImpl);
        this.links.addAll(heap.links);
        assert (n2 + heap.nodes.size() == this.nodes.size());
        assert (n2 + heap.directChildren.size() == this.directChildren.size());
        this.addUnderMe(aNode, aNode2, aLinkImpl);
    }

    public void computeRows() {
        boolean bl;
        for (ANode object : this.nodes.values()) {
            object.setRow(Integer.MIN_VALUE);
        }
        this.nodes.values().iterator().next().setRow(0);
        do {
            this.onePass();
            bl = false;
            for (ANode aNode : this.nodes.values()) {
                if (aNode.getRow() != Integer.MIN_VALUE) continue;
                Map.Entry<ANode, ALink> entry = this.getSmallestRowOfChildren(aNode);
                if (entry != null) {
                    aNode.setRow(this.getStartingRow(entry));
                }
                bl = true;
            }
        } while (bl);
        this.minToZero();
    }

    private int getStartingRow(Map.Entry<ANode, ALink> entry) {
        assert (entry.getValue().getNode2() == entry.getKey());
        return entry.getValue().getNode2().getRow() - entry.getValue().getDiffHeight();
    }

    private void minToZero() {
        int n = Integer.MAX_VALUE;
        for (ANode aNode : this.nodes.values()) {
            n = Math.min(n, aNode.getRow());
        }
        if (n == Integer.MIN_VALUE) {
            throw new IllegalStateException();
        }
        if (n != 0) {
            for (ANode aNode : this.nodes.values()) {
                aNode.setRow(aNode.getRow() - n);
            }
        }
    }

    private Map.Entry<ANode, ALink> getSmallestRowOfChildren(ANode aNode) {
        assert (aNode.getRow() == Integer.MIN_VALUE);
        Map.Entry<ANode, ALink> entry = null;
        for (Map.Entry<ANode, ALink> entry2 : this.directChildren.get(aNode).entrySet()) {
            ANode aNode2 = entry2.getKey();
            if (aNode2.getRow() == Integer.MIN_VALUE || entry != null && this.getStartingRow(entry2) >= this.getStartingRow(entry)) continue;
            entry = entry2;
        }
        return entry;
    }

    private void onePass() {
        boolean bl;
        do {
            bl = false;
            for (ANode aNode : this.nodes.values()) {
                int n = aNode.getRow();
                if (n == Integer.MIN_VALUE) continue;
                for (Map.Entry<ANode, ALink> entry : this.directChildren.get(aNode).entrySet()) {
                    ANode aNode2 = entry.getKey();
                    int n2 = entry.getValue().getDiffHeight();
                    if (aNode2.getRow() != Integer.MIN_VALUE && aNode2.getRow() >= n + n2) continue;
                    aNode2.setRow(n + n2);
                    bl = true;
                }
            }
        } while (bl);
    }

    private ANode getNode(String string) {
        ANode aNode = this.nodes.get(string);
        if (aNode == null) {
            aNode = this.createNewNode(string);
        }
        return aNode;
    }

    private ANode createNewNode(String string) {
        ANodeImpl aNodeImpl = new ANodeImpl(string);
        this.directChildren.put(aNodeImpl, new LinkedHashMap());
        this.nodes.put(string, aNodeImpl);
        assert (this.directChildren.size() == this.nodes.size());
        return aNodeImpl;
    }

    public ANode getExistingNode(String string) {
        return this.nodes.get(string);
    }

    public List<ALink> getLinks() {
        return Collections.unmodifiableList(this.links);
    }

    public List<ANode> getNodes() {
        return Collections.unmodifiableList(new ArrayList<ANode>(this.nodes.values()));
    }

    HashSet<ANode> getAllChildren(ANode aNode) {
        HashSet<ANode> hashSet = new HashSet<ANode>(this.directChildren.get(aNode).keySet());
        int n = 0;
        do {
            n = hashSet.size();
            for (ANode aNode2 : new HashSet<ANode>(hashSet)) {
                hashSet.addAll(this.getAllChildren(aNode2));
            }
        } while (hashSet.size() != n);
        return hashSet;
    }

    public void addLink(String string, int n, Object object) {
        ANode aNode;
        LinkString linkString = new LinkString(string);
        ANode aNode2 = this.getNode(linkString.getNode1());
        if (aNode2 == (aNode = this.getNode(linkString.getNode2()))) {
            return;
        }
        ALinkImpl aLinkImpl = new ALinkImpl(aNode2, aNode, n, object);
        this.links.add(aLinkImpl);
        if (this.getAllChildren(aNode).contains(aNode2)) {
            this.addUnderMe(aNode, aNode2, aLinkImpl);
        } else {
            this.addUnderMe(aNode2, aNode, aLinkImpl);
        }
    }

    public ANode addNode(String string) {
        if (this.nodes.containsKey(string)) {
            throw new IllegalArgumentException();
        }
        return this.createNewNode(string);
    }

    private void addUnderMe(ANode aNode, ANode aNode2, ALinkImpl aLinkImpl) {
        assert (!this.getAllChildren(aNode2).contains(aNode));
        this.directChildren.get(aNode).put(aNode2, aLinkImpl);
        assert (this.getAllChildren(aNode).contains(aNode2));
        assert (!this.getAllChildren(aNode2).contains(aNode));
    }

    public int getRowMax() {
        int n = Integer.MIN_VALUE;
        for (ANode aNode : this.nodes.values()) {
            n = Math.max(n, aNode.getRow());
        }
        return n;
    }
}

