package PROP::LinkTest;

use strict;
use base qw/Test::Unit::TestCase/;

use Data::Dumper;
use PROP::DBH;
use PROP::Util;
use PROP::Link;
use PROP::TestCommon;
use PROP::Query::Link;

sub new {
    my ($invocant, @args) = @_;
    my $self = $invocant->SUPER::new(@args);

    return $self;
}

sub set_up {
    my ($self) = @_;

    drop_tables();
    create_tables();
}

sub tear_down {
    my ($self) = @_;

    drop_tables();
}

sub test_attributes {
    my ($self) = @_;

    my $links = create_links();

    $self->assert_equals('LinkFooToBiz', $links->[0]->get_table_name());

    $self->assert_equals('Dummy::Foo', $links->[0]->get_parent_class());
    $self->assert_equals('Dummy::Biz', $links->[0]->get_child_class());

    $self->assert_equals('Foo', $links->[0]->get_parent_table_name());
    $self->assert_equals('Biz', $links->[0]->get_child_table_name());

    $self->assert_equals('foo_id', $links->[0]->get_parent_field_name());
    $self->assert_equals('biz_id', $links->[0]->get_child_field_name());

    my @contextual_fields = $links->[0]->get_contextual_field_names();
    $self->assert_equals($contextual_fields[$_ - 1], 'c' . $_) foreach (1..3);
}

sub test_update {
    my ($self) = @_;

    my ($f, $b, $fz, $links) = populate_database();

    # NEW

    my $fc = new PROP::Conditions::Foreign($links->[0], 'children',
					   ['l.foo_id = ?', 'l.biz_id = ?'], [2, 3]);

    my $query = new PROP::Query::Link($fc);

#    my $conditions =
#	new PROP::Conditions::Local(['l.foo_id = ?', 'l.biz_id = ?'], [2, 3]);
#
#    my $query = new PROP::Query::Link($links->[0], 'children', $conditions);

    my $rs = new PROP::ResultSet::Link($query);
    my $results = $rs->get_all_results();
    my $obj = $results->[0]->get_relatives()->[0];

    $self->assert_equals(3, $obj->get_pk_value());
    $self->assert_equals(1, $obj->get_contextual_value('c1'));
    $self->assert_equals(2, $obj->get_contextual_value('c2'));

    $links->[0]->update(2, 3, { c1 => 5, c2 => 7});

    $rs = new PROP::ResultSet::Link($query);
    $results = $rs->get_all_results();
    $obj = $results->[0]->get_relatives()->[0];

    $self->assert_equals(3, $obj->get_pk_value());
    $self->assert_equals(5, $obj->get_contextual_value('c1'));
    $self->assert_equals(7, $obj->get_contextual_value('c2'));
}

sub test_delete {
    my ($self) = @_;

    my ($f, $b, $fz, $links) = populate_database();

    # NEW

    my $fc = new PROP::Conditions::Foreign($links->[0],
					   'children',
					   ['l.foo_id in (?, ?)',
					    'l.biz_id in (?, ?)'],
					   [$f->[0]->get_pk_value(),
					    $f->[2]->get_pk_value(),
					    $b->[0]->get_pk_value(),
					    $b->[1]->get_pk_value()]);

    my $query = new PROP::Query::Link($fc, ['l.biz_id']);

#     my $conditions =
# 	new PROP::Conditions::Local(['l.foo_id in (?, ?)',
# 				    'l.biz_id in (?, ?)'],
# 				   [$f->[0]->get_pk_value(),
# 				    $f->[2]->get_pk_value(),
# 				    $b->[0]->get_pk_value(),
# 				    $b->[1]->get_pk_value()]);

#     my $query = new PROP::Query::Link($links->[0], 'children', $conditions, ['l.biz_id']);

    my $results = new PROP::ResultSet::Link($query)->get_all_results();

    $self->assert_equals(2, scalar(@$results));

    $self->assert_equals($f->[0]->get_pk_value(), $results->[0]->get_pk_value());
    $self->assert_equals($b->[0]->get_pk_value(), $results->[0]->get_relatives()->[0]->get_pk_value());
    $self->assert_equals($b->[1]->get_pk_value(), $results->[0]->get_relatives()->[1]->get_pk_value());

    $self->assert_equals($f->[2]->get_pk_value(), $results->[1]->get_pk_value());
    $self->assert_equals($b->[0]->get_pk_value(), $results->[1]->get_relatives()->[0]->get_pk_value());
    $self->assert_equals($b->[1]->get_pk_value(), $results->[1]->get_relatives()->[1]->get_pk_value());

    $links->[0]->delete($f->[0], $b->[0]);
    $links->[0]->delete($f->[2], $b->[0]);
    $links->[0]->delete($f->[0], $b->[1]);

    $results = new PROP::ResultSet::Link($query)->get_all_results();

    $self->assert_equals(1, scalar(@$results));
    $self->assert_equals(1, scalar(@{$results->[0]->get_relatives()}));
    $self->assert_equals($f->[2]->get_pk_value(), $results->[0]->get_pk_value());
    $self->assert_equals($b->[1]->get_pk_value(), $results->[0]->get_relatives()->[0]->get_pk_value());
}

1;

=head1 Author

Andrew Gibbs (awgibbs@awgibbs.com,andrew.gibbs@nist.gov)

=head1 Legalese

This software was developed at the National Institute of Standards and
Technology by employees of the Federal Government in the course of
their official duties. Pursuant to title 17 Section 105 of the United
States Code this software is not subject to copyright protection and
is in the public domain. PROP is an experimental system. NIST
assumes no responsibility whatsoever for its use by other parties, and
makes no guarantees, expressed or implied, about its quality,
reliability, or any other characteristic. We would appreciate
acknowledgement if the software is used.  This software can be
redistributed and/or modified freely provided that any derivative
works bear some notice that they are derived from it, and any modified
versions bear some notice that they have been modified.
